<?php
session_start();
header('Content-Type: text/html; charset=utf-8');

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

include 'db.php';

// Asegurar que la conexión usa utf8mb4
$conn->set_charset("utf8mb4");

// Obtener el SSID de la red seleccionada
$ssid = $_GET['ssid'] ?? '';

if ($ssid) {
    // Consultar los detalles de la red Wi-Fi seleccionada
    $sql = "SELECT * FROM wifi_passwords WHERE ssid = '$ssid'";
    $result = $conn->query($sql);
    $wifi_data = $result->fetch_assoc();
}

include 'header.php';
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Conectar a Red Wi-Fi</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header>
        <h1>Conectar a la Red Wi-Fi</h1>
        <nav>
            <ul>
                <li><a href="dashboard.php">Dashboard</a></li>
                <li><a href="ver_wifi.php">Ver Redes Wi-Fi</a></li>
                <li><a href="logout.php">Cerrar sesión</a></li>
            </ul>
        </nav>
    </header>
    
    <main>
        <?php if ($wifi_data): ?>
            <section>
                <h2>Detalles de la Red Wi-Fi: <?php echo htmlspecialchars($wifi_data['ssid'], ENT_QUOTES, 'UTF-8'); ?></h2>
                <p><strong>Bloque:</strong> <?php echo htmlspecialchars($wifi_data['bloque'], ENT_QUOTES, 'UTF-8'); ?></p>
                <p><strong>Piso:</strong> <?php echo htmlspecialchars($wifi_data['piso'], ENT_QUOTES, 'UTF-8'); ?></p>
                <p><strong>Contraseña:</strong> <?php echo htmlspecialchars($wifi_data['password'], ENT_QUOTES, 'UTF-8'); ?></p>
            </section>
        <?php else: ?>
            <p>Red Wi-Fi no encontrada.</p>
        <?php endif; ?>
    </main>

    <?php include 'footer.php'; ?>
</body>
</html>
