<?php
session_start();

function generateToken($user_id) {
    $secret_key = "f099e87ced03203736d7b84c0383e9352d1f4c8755d1206ae915f0ba13923ed6";
    $timestamp = time();
    $token = hash_hmac('sha256', $user_id . $timestamp, $secret_key);
    return $token . ":" . $timestamp;
}

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

include 'db.php';

// Generamos el token
$user_id = $_SESSION['user_id'];
$token = generateToken($user_id);
$urlGestionRondas = "https://polisuperior.com/tools/visitec/login.php?token=$token";
$urlGestionPuntos = "https://polisuperior.com/tools/network/index.php?token=$token";
$urlMapasInfraestructura = "https://polisuperior.com/tools/mapas/mapa1.php?token=$token";
$urlMapasServidores = "https://polisuperior.com/tools/mapas/servidores.php?token=$token";
$urlGestionServidores = "https://dashboard.uptimerobot.com/monitors?token=$token";

// Asegurar que la conexión usa utf8mb4
$conn->set_charset("utf8mb4");

// Consultar estadísticas
$sql = "SELECT COUNT(DISTINCT dispositivo) AS total_routers FROM wifi_passwords";
$result = $conn->query($sql);
$total_routers = $result->fetch_assoc()['total_routers'];

$sql = "SELECT COUNT(*) AS total_wifi FROM wifi_passwords";
$result = $conn->query($sql);
$total_wifi = $result->fetch_assoc()['total_wifi'];

$sql = "SELECT ssid, created_at, dispositivo FROM wifi_passwords ORDER BY created_at DESC LIMIT 5";
$latest_wifi = $conn->query($sql);

include 'header.php';
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <link rel="stylesheet" href="styles.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        .container { display: flex; flex: 1; }
        .sidebar {
            width: 250px;
            background-color: #2b3ca9;
            color: white;
            padding: 20px;
            position: fixed;
            height: 100%;
            overflow-y: auto;
        }
        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            margin-bottom: 10px;
            padding: 8px;
        }
        .sidebar a:hover {
            background-color: #575757;
            border-radius: 4px;
        }
        .submenu ul {
            list-style: none;
            padding-left: 15px;
            margin: 0;
        }
        .submenu-items li a {
            font-size: 14px;
            color: white;
            display: block;
            padding: 6px;
        }
        .submenu-items li a:hover {
            background-color: #444;
            border-radius: 4px;
        }
        .content {
            margin-left: 250px;
            padding: 20px;
            flex: 1;
        }
        header {
            background-color: #2b3ca9;
            color: #fff;
            padding: 1rem 0;
            text-align: center;
        }
        main { padding: 2rem; }
        section {
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            margin-bottom: 2rem;
            padding: 1.5rem;
        }
        section h2 {
            border-bottom: 2px solid #2b3ca9;
            padding-bottom: 0.5rem;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 1rem;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 0.5rem;
            text-align: left;
        }
        th {
            background-color: #2b3ca9;
            color: #fff;
        }
        footer {
            background-color: #333;
            color: #fff;
            text-align: center;
            padding: 1rem 0;
            position: fixed;
            width: 100%;
            bottom: 0;
        }
        .menu-icon {
            display: none;
            font-size: 24px;
            cursor: pointer;
            color: white;
        }
        @media (max-width: 768px) {
            .container { flex-direction: column; }
            .sidebar {
                transform: translateX(-100%);
                width: 200px;
                position: absolute;
            }
            .sidebar.active {
                transform: translateX(0);
            }
            .content {
                margin-left: 0;
                padding: 10px;
            }
            .menu-icon {
                display: block;
                text-align: left;
                padding: 10px;
            }
        }
    </style>
</head>
<body>
<div class="container">
    <div class="menu-icon" onclick="toggleMenu()">☰</div>
    <div class="sidebar" id="sidebar">
        <a href="https://politecnicodecolombia.com/nextcloud/index.php/login?redirect_url=/nextcloud/index.php/apps/dashboard/" target="_blank">
            <i class="fa-solid fa-cloud-upload-alt"></i> Nextcloud
        </a>
         <a href="http://politecnicovirtualdecolombia.com/fileserver/index.php" target="_blank">
            <i class="fa-solid fa-folder"></i> FileServer
        </a>
        <a href="https://grupopolitecnicodecolombia.co/help/login.php" target="_blank">
            <i class="fa-solid fa-ticket"></i> Tickets
        </a>
        <a href="registrar_wifi.php" target="_blank">
            <i class="fa-solid fa-wifi"></i> Registrar Red Wi-Fi
        </a>
        <a href="ver_wifi.php" target="_blank">
            <i class="fa-solid fa-network-wired"></i> Ver Redes Wi-Fi
        </a>
        <a href="<?php echo $urlGestionRondas; ?>" target="_blank">
            <i class="fa-solid fa-shield-halved"></i> Gestión Espacios
        </a>
        <a href="<?php echo $urlGestionPuntos; ?>" target="_blank">
            <i class="fa-solid fa-server"></i> Gestión Redes de Datos
        </a>
        <a href="<?php echo $urlGestionServidores; ?>" target="_blank">
            <i class="fa-solid fa-network-wired"></i> Gestión Monitoreo Servidores        </a>

        
        <div class="submenu">
            <a href="#" onclick="toggleSubmenu(event)"><i class="fa-solid fa-sitemap"></i> Mapas Infraestructura <i class="fa fa-caret-down" style="float: right;"></i></a>
            <ul class="submenu-items" style="display: none;">
                <li><a href="<?php echo $urlMapasInfraestructura; ?>&block=1" target="_blank">Bloque 1</a></li>
                <li><a href="<?php echo $urlMapasInfraestructura; ?>&block=2" target="_blank">Bloque 2</a></li>
                <li><a href="<?php echo $urlMapasInfraestructura; ?>&block=3" target="_blank">Bloque 3</a></li>
                <li><a href="<?php echo $urlMapasInfraestructura; ?>&block=4" target="_blank">Bloque 4</a></li>
                <li><a href="<?php echo $urlMapasServidores; ?>&block=3" target="_blank">Servidores</a></li>
            </ul>
        </div>
<div class="submenu">
            <a href="#" onclick="toggleSubmenu(event)">
  <i class="fa-solid fa-chart-line"></i> Seguimiento al Proceso 
  <i class="fa fa-caret-down" style="float: right;"></i>
</a>
<ul class="submenu-items" style="display: none;">
    <li>
      <a href="https://polisuperior.com/tools/fishbone_app/login.php" target="_blank">
        <i class="fas fa-fish"></i> Diagrama de Ishikawa
      </a>
    </li>
    <li>
      <a href="https://polisuperior.com/tools/fishbone_app/images/PR.pdf" target="_blank">
        <i class="fas fa-file-pdf"></i> PR
      </a>
    </li>
</ul>

        </div>
        <a href="logout.php"><i class="fa-solid fa-right-from-bracket"></i> Cerrar sesión</a>
    </div>

    <div class="content">
        <header>
            <h1>Bienvenido al Panel de Administración : GESTIÓN TECNOLÓGICA</h1>
        </header>
        <main>
            <section>
                <h2>Estadísticas del Sistema</h2>
                <p><strong>Total de routers:</strong> <?php echo htmlspecialchars($total_routers); ?></p>
                <p><strong>Total de redes Wi-Fi:</strong> <?php echo htmlspecialchars($total_wifi); ?></p>
            </section>
            <section>
                <h2>Últimas Redes Wi-Fi Registradas</h2>
                <table>
                    <thead>
                    <tr>
                        <th>SSID</th>
                        <th>Fecha de Registro</th>
                        <th>Dispositivo</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php while ($row = $latest_wifi->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($row['ssid']); ?></td>
                            <td><?php echo date('d-m-Y H:i:s', strtotime($row['created_at'])); ?></td>
                            <td><?php echo htmlspecialchars($row['dispositivo']); ?></td>
                        </tr>
                    <?php endwhile; ?>
                    </tbody>
                </table>
            </section>
        </main>
    </div>
</div>

<footer>
    <?php include 'footer.php'; ?>
</footer>

<script>
    function toggleMenu() {
        const sidebar = document.getElementById('sidebar');
        sidebar.classList.toggle('active');
    }

    function toggleSubmenu(event) {
        event.preventDefault();
        const submenu = event.currentTarget.nextElementSibling;
        submenu.style.display = submenu.style.display === 'block' ? 'none' : 'block';
    }
</script>

</body>
</html>
