<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] != 'admin') {
    header("Location: login.php");
    exit();
}

include 'db.php';

// Función para sanitizar la entrada
function sanitize_input($data) {
    return htmlspecialchars(stripslashes(trim($data)));
}

// Función para enviar notificación a múltiples destinatarios
function enviar_notificacion($destinatarios, $asunto, $mensaje) {
    $headers = "From: no-reply@polisuperior.com\r\n";
    $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";

    foreach ($destinatarios as $destinatario) {
        if (!mail($destinatario, $asunto, $mensaje, $headers)) {
            error_log("Error enviando correo a $destinatario");
        }
    }
}

// --- LÓGICA CUANDO SE ENVÍA EL FORMULARIO (MÉTODO POST) ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = $_POST['id'];

    // Obtener los datos ANTIGUOS antes de actualizar
    $sql_anterior = "SELECT ssid, password FROM wifi_passwords WHERE id = ?";
    $stmt_anterior = $conn->prepare($sql_anterior);
    $stmt_anterior->bind_param("i", $id);
    $stmt_anterior->execute();
    $resultado_anterior = $stmt_anterior->get_result();
    $wifi_anterior = $resultado_anterior->fetch_assoc();
    $ssid_anterior = $wifi_anterior['ssid'];
    $password_anterior_encriptado = $wifi_anterior['password'];
    $stmt_anterior->close();

    // Obtener los nuevos datos del formulario
    $ssid_nuevo = sanitize_input($_POST['ssid']);
    $password_nuevo = sanitize_input($_POST['password']);
    $bloque = sanitize_input($_POST['bloque']);
    $piso = sanitize_input($_POST['piso']);
    $dispositivo = sanitize_input($_POST['dispositivo']);
    $proveedor = sanitize_input($_POST['proveedor']);
    $encrypted_password = openssl_encrypt($password_nuevo, 'AES-256-CBC', 'tu_clave_secreta', 0, 'tu_vector_inicializacion');

    // Preparamos y ejecutamos la actualización
    $sql_update = "UPDATE wifi_passwords SET ssid=?, password=?, bloque=?, piso=?, dispositivo=?, proveedor=? WHERE id=?";
    $stmt_update = $conn->prepare($sql_update);
    $stmt_update->bind_param("ssssssi", $ssid_nuevo, $encrypted_password, $bloque, $piso, $dispositivo, $proveedor, $id);

    if ($stmt_update->execute()) {
        // Lógica para decidir si enviar notificación
        $enviar_notificacion = false;
        $detalles_cambio = "";

        $password_anterior_descifrado = openssl_decrypt($password_anterior_encriptado, 'AES-256-CBC', 'tu_clave_secreta', 0, 'tu_vector_inicializacion');

        if ($ssid_anterior !== $ssid_nuevo) {
            $enviar_notificacion = true;
            $detalles_cambio .= "Nombre de red (SSID) cambiado de: '$ssid_anterior' a '$ssid_nuevo'.\n";
        }

        if ($password_anterior_descifrado !== $password_nuevo) {
            $enviar_notificacion = true;
            $detalles_cambio .= "La contraseña para la red '$ssid_nuevo' ha sido actualizada.\n";
        }

        if ($enviar_notificacion) {
            $docentes = [
                "castro440@hotmail.com",
            "henrycaxtro@gmail.com",
           
            ];

            $asunto = "⚠️ Cambio Importante en Red Wi-Fi";
            $mensaje = "Estimados Colaboradores,\n\nSe han realizado cambios en una red Wi-Fi:\n\n";
            $mensaje .= $detalles_cambio;
            $mensaje .= "\nPor favor, recuerden consultar el portal de redes para mantenerse actualizados:\n";
            $mensaje .= "wifi.polisuperior.com\n";
            $mensaje .= "Usuario: colaboradores@politecnicodecolombia.edu.co\n";
            $mensaje .= "Contraseña: Colaborador2025*\n\n";
            $mensaje .= "Saludos,\nGestión Tecnólogica - 2025";

            enviar_notificacion($docentes, $asunto, $mensaje);
        }
        
        header("Location: ver_wifi.php?status=updated");
        exit();
    } else {
        header("Location: editar_wifi.php?id=" . $id . "&error=update_failed");
        exit();
    }
    $stmt_update->close();
}

// --- LÓGICA PARA CARGAR DATOS SI ES UNA EDICIÓN (MÉTODO GET) ---
 $wifi = null;
if (isset($_GET['id'])) {
    $id_get = $_GET['id'];
    $sql = "SELECT * FROM wifi_passwords WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id_get);
    $stmt->execute();
    $result = $stmt->get_result();
    $wifi = $result->fetch_assoc();
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Red Wi-Fi</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <?php include 'header.php'; ?>

    <div class="form-container">
        <h2>Editar Contraseña Wi-Fi</h2>
        <?php 
            if (isset($_GET['error'])) {
                echo '<p class="error-message">Hubo un error al actualizar. Inténtalo de nuevo.</p>';
            }
        ?>
        <?php if ($wifi): ?>
        <form action="editar_wifi.php" method="POST">
            <input type="hidden" name="id" value="<?php echo $wifi['id']; ?>">

            <label>📡 SSID (Nombre de Red):</label>
            <input type="text" name="ssid" value="<?php echo htmlspecialchars($wifi['ssid'], ENT_QUOTES, 'UTF-8'); ?>" required><br><br>

            <label>🔑 Nueva Contraseña:</label>
            <input type="password" id="password" name="password" value="<?php echo htmlspecialchars(openssl_decrypt($wifi['password'], 'AES-256-CBC', 'tu_clave_secreta', 0, 'tu_vector_inicializacion'), ENT_QUOTES, 'UTF-8'); ?>" required>
            <input type="checkbox" onclick="togglePassword()"> Ver Contraseña<br><br>

            <label>🏢 Bloque:</label>
            <select name="bloque" required>
                <option value="1" <?php if ($wifi['bloque'] == '1') echo 'selected'; ?>>Bloque 1</option>
                <option value="2" <?php if ($wifi['bloque'] == '2') echo 'selected'; ?>>Bloque 2</option>
                <option value="3" <?php if ($wifi['bloque'] == '3') echo 'selected'; ?>>Bloque 3</option>
                <option value="4" <?php if ($wifi['bloque'] == '4') echo 'selected'; ?>>Bloque 4</option>
            </select><br><br>

            <label>📶 Piso:</label>
            <select name="piso" required>
                <option value="1" <?php if ($wifi['piso'] == '1') echo 'selected'; ?>>Piso 1</option>
                <option value="2" <?php if ($wifi['piso'] == '2') echo 'selected'; ?>>Piso 2</option>
                <option value="3" <?php if ($wifi['piso'] == '3') echo 'selected'; ?>>Piso 3</option>
                <option value="4" <?php if ($wifi['piso'] == '4') echo 'selected'; ?>>Piso 4</option>
                <option value="5" <?php if ($wifi['piso'] == '5') echo 'selected'; ?>>Piso 5</option>
            </select><br><br>

            <label>💻 Dispositivo:</label>
            <input type="text" name="dispositivo" value="<?php echo htmlspecialchars($wifi['dispositivo'], ENT_QUOTES, 'UTF-8'); ?>" required><br><br>

            <label>🌍 Proveedor de Internet:</label>
            <select name="proveedor" required>
                <option value="tigo" <?php if ($wifi['proveedor'] == 'tigo') echo 'selected'; ?>>Tigo</option>
                <option value="claro" <?php if ($wifi['proveedor'] == 'claro') echo 'selected'; ?>>Claro</option>
                <option value="liberty" <?php if ($wifi['proveedor'] == 'liberty') echo 'selected'; ?>>Liberty</option>
            </select><br><br>

            <button type="submit">✅ Actualizar</button>
        </form>
        <?php else: ?>
            <p>No se encontró la red Wi-Fi para editar.</p>
        <?php endif; ?>
    </div>

    <?php include 'footer.php'; ?>

    <script>
        function togglePassword() {
            var passwordInput = document.getElementById("password");
            if (passwordInput.type === "password") {
                passwordInput.type = "text";
            } else {
                passwordInput.type = "password";
            }
        }
    </script>
</body>
</html>