<?php
session_start();
// Permitimos que CUALQUIER usuario logueado genere el archivo.
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

include 'db.php';

// --- 1. Obtener TODAS las redes de la base de datos ---
 $sql = "SELECT ssid, password, bloque, piso, dispositivo, proveedor FROM wifi_passwords ORDER BY bloque, piso, ssid";
 $result = $conn->query($sql);

// --- 2. Generar el contenido HTML para el archivo offline ---
 $html_content = '<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Redes Wi-Fi - Versión Offline</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; background-color: #f4f4f4; }
        .container { max-width: 800px; margin: auto; background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        h1 { color: #333; text-align: center; }
        .info { background-color: #e7f3fe; border-left: 6px solid #2196F3; padding: 10px; margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 12px; text-align: left; }
        th { background-color: #f2f2f2; }
        tr:nth-child(even) { background-color: #f9f9f9; }
        .footer { text-align: center; margin-top: 30px; font-size: 12px; color: #777; }
    </style>
</head>
<body>
    <div class="container">
        <h1>📶 Listado de Redes Wi-Fi</h1>
        <div class="info">
            <strong>Versión Offline</strong><br>
             Recuerde que esta Información esta sujeta a cambios Este archivo fue generado el: <strong>' . date('d/m/Y H:i:s') . '</strong><br>
            Para la información más reciente, visite el portal en línea: <strong>wifi.polisuperior.com</strong>
        </div>
        
        <table>
            <thead>
                <tr>
                    <th>SSID (Red)</th>
                    <th>Contraseña</th>
                    <th>Bloque</th>
                    <th>Piso</th>
                    <th>Dispositivo</th>
                    <th>Proveedor</th>
                </tr>
            </thead>
            <tbody>';

// Recorremos los resultados y añadimos cada fila a la tabla
while ($row = $result->fetch_assoc()) {
    // Desciframos la contraseña para mostrarla
    $password_descifrada = openssl_decrypt($row['password'], 'AES-256-CBC', 'tu_clave_secreta', 0, 'tu_vector_inicializacion');
    
    $html_content .= '<tr>
        <td>' . htmlspecialchars($row['ssid']) . '</td>
        <td>' . htmlspecialchars($password_descifrada) . '</td>
        <td>' . htmlspecialchars($row['bloque']) . '</td>
        <td>' . htmlspecialchars($row['piso']) . '</td>
        <td>' . htmlspecialchars($row['dispositivo']) . '</td>
        <td>' . htmlspecialchars($row['proveedor']) . '</td>
    </tr>';
}

 $html_content .= '
            </tbody>
        </table>
        
        <div class="footer">
            <p><strong>Acceso al Portal:</strong></p>
            <p>Usuario: colaboradores@politecnicodecolombia.edu.co</p>
            <p>Contraseña: Colaborador2025*</p>
        </div>
    </div>
</body>
</html>';

// --- 3. Enviar las cabeceras para forzar la descarga del archivo ---
// --- ¡CAMBIO AQUÍ! El nombre del archivo ahora incluye la fecha ---
 $filename = "redes_wifi_" . date('d-m-Y') . ".html";
header('Content-Type: text/html');
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Content-Length: ' . strlen($html_content));

// --- 4. Imprimir el contenido y terminar el script ---
echo $html_content;
exit();

?>