<?php
session_start();
include 'db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    // Buscar el usuario en la base de datos
    $sql = "SELECT * FROM usuarios WHERE email=?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();
        // Verificar la contraseña
        if (password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['nombre'];
            $_SESSION['user_role'] = $user['rol'];
           if ($user['rol'] == 'admin') {
                header("Location: dashboard.php"); // Redirigir al dashboard principal para administradores
            } else {
                header("Location: ver_wifi.php"); // Redirigir a la página de redes Wi-Fi para usuarios normales
            }
            exit();
        } else {
            $error = "Contraseña incorrecta.";
        }
    } else {
        $error = "Usuario no encontrado.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Iniciar Sesión</title>
    <link rel="stylesheet" href="styles.css">
    
    <!-- ======================================= -->
    <!--    ESTILOS DIRECTOS PARA LOS BOTONES    -->
    <!-- ======================================= -->
    <style>
        /* Contenedor para los botones extra */
        .login-extra-buttons {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin-top: 20px;
            flex-wrap: wrap;
        }

        /* Estilo base para ambos botones */
        .login-extra-buttons a {
            display: inline-block;
            padding: 12px 25px; /* El padding determina el tamaño ahora */
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            text-align: center;
            transition: background-color 0.3s, transform 0.2s;
            /* ¡OJO! Ya no hay "flex-grow" ni "width" aquí para que no sean tan anchos */
        }

        /* Estilo específico para el botón de WhatsApp */
        .whatsapp-btn {
            background-color: #25D366;
            color: white;
        }

        .whatsapp-btn:hover {
            background-color: #128C7E;
            transform: translateY(-2px);
        }

        /* Estilo específico para el botón de Tickets */
        .ticket-btn {
            background-color: #007bff;
            color: white;
        }

        .ticket-btn:hover {
            background-color: #0056b3;
            transform: translateY(-2px);
        }

        /* Mejora para pantallas pequeñas (celular) */
        @media (max-width: 600px) {
            .login-extra-buttons {
                flex-direction: column; /* Los apila verticalmente en el móvil */
                align-items: center;
            }

            /* En móvil, los botones mantendrán su tamaño ajustado al texto */
            .login-extra-buttons a {
                width: auto; /* El ancho se ajusta al contenido */
            }
        }
    </style>
</head>
<body>
    <?php include 'header.php'; ?>

    <div class="login-container">
        <h2>Iniciar Sesión</h2>
        <?php if (isset($error)): ?>
            <p class="error-message"><?php echo $error; ?></p>
        <?php endif; ?>
        <form action="login.php" method="POST" class="login-form">
            <label for="email">Email:</label>
            <input type="email" name="email" id="email" placeholder="Ingresa tu correo" required>

            <label for="password">Contraseña:</label>
            <input type="password" name="password" id="password" placeholder="Ingresa tu contraseña" required>

            <button type="submit">Iniciar sesión</button>
        </form>

        <!-- ======================================= -->
        <!-- AQUÍ ESTÁN LOS NUEVOS BOTONES/ENLACES -->
        <!-- ======================================= -->
        <div class="login-extra-buttons">
            <!-- Botón de WhatsApp -->
            <!-- ¡IMPORTANTE! Reemplaza '573001234567' con tu número de teléfono -->
            <a href="https://api.whatsapp.com/send?phone=573011369923" target="_blank" class="whatsapp-btn">
                WhatsApp
            </a>

            <!-- Botón de Tickets Policolombia -->
            <!-- ¡IMPORTANTE! Reemplaza 'tickets_policolombia.php' con la URL correcta -->
            <a href="https://grupopolitecnicodecolombia.co/help/login.php" target="_blank" class="ticket-btn">
                Tickets
            </a>
        </div>

    </div>

    <?php include 'footer.php'; ?>
</body>
</html>