<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] != 'admin') {
    header("Location: login.php");
    exit();
}

include 'db.php';
include 'enviar_notificacion.php'; // Incluimos tu archivo de notificación

// Función para sanitizar los datos
function sanitize_input($data) {
    return htmlspecialchars(stripslashes(trim($data)));
}

// --- LÓGICA CUANDO SE ENVÍA EL FORMULARIO (MÉTODO POST) ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Obtener los datos del formulario
    $ssid = sanitize_input($_POST['ssid']);
    $password = sanitize_input($_POST['password']);
    $bloque = sanitize_input($_POST['bloque']);
    $piso = sanitize_input($_POST['piso']);
    $dispositivo = sanitize_input($_POST['dispositivo']);
    $proveedor = sanitize_input($_POST['proveedor']);

    // Encriptar la contraseña antes de guardarla
    $encrypted_password = openssl_encrypt($password, 'AES-256-CBC', 'tu_clave_secreta', 0, 'tu_vector_inicializacion');

    // Preparar la consulta para insertar la nueva red
    $sql = "INSERT INTO wifi_passwords (ssid, password, bloque, piso, dispositivo, proveedor) VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssss", $ssid, $encrypted_password, $bloque, $piso, $dispositivo, $proveedor);

    // Ejecutar la consulta
    if ($stmt->execute()) {
        // --- LISTA DE DESTINATARIOS ORGANIZADA Y LIMPIA ---
        $docentes = [
            "castro440@hotmail.com",
            "henrycaxtro@gmail.com",
           
        ];

        // --- Mensaje de notificación mejorado ---
        $asunto = "🆕 Nueva Red Wi-Fi Registrada";
        $mensaje = "Estimados Colaboradores,\n\nSe ha registrado una nueva red Wi-Fi en el sistema:\n\n";
        $mensaje .= "📶 SSID (Nombre): " . htmlspecialchars($ssid) . "\n";
        $mensaje .= "🏢 Bloque: " . htmlspecialchars($bloque) . "\n";
        $mensaje .= "🏬 Piso: " . htmlspecialchars($piso) . "\n";
        $mensaje .= "🔌 Dispositivo: " . htmlspecialchars($dispositivo) . "\n";
        $mensaje .= "📡 Proveedor: " . htmlspecialchars($proveedor) . "\n\n";
        $mensaje .= "Pueden consultar todas las redes en el portal:\n";
        $mensaje .= "wifi.polisuperior.com\n";
        $mensaje .= "Usuario: colaboradores@politecnicodecolombia.edu.co\n";
        $mensaje .= "Contraseña: Colaborador2025*\n\n";
        $mensaje .= "Saludos,\nEl Sistema de Notificaciones";

        // Enviar la notificación
        enviar_notificacion($docentes, $asunto, $mensaje);
        
        // --- Redirección después del éxito ---
        header("Location: ver_wifi.php?status=added");
        exit(); // Siempre poner exit() después de una redirección

    } else {
        // En caso de error, redirigir de vuelta con un mensaje
        header("Location: registrar_wifi.php?error=add_failed");
        exit();
    }

    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrar Nueva Red Wi-Fi</title>
    <link rel="stylesheet" href="styles.css">
    <script>
        function togglePassword() {
            var passwordField = document.getElementById("password");
            var showPasswordCheckbox = document.getElementById("showPassword");
            passwordField.type = showPasswordCheckbox.checked ? "text" : "password";
        }
    </script>
</head>
<body>
    <?php include 'header.php'; ?>

    <div class="form-container">
        <h2>Registrar Nueva Red Wi-Fi</h2>

        <!-- Mensaje de error si lo hay -->
        <?php if (isset($_GET['error'])): ?>
            <p class="error-message">❌ Hubo un error al registrar la red. Por favor, inténtalo de nuevo.</p>
        <?php endif; ?>

        <form action="registrar_wifi.php" method="POST">
            <label>📶 SSID:</label>
            <input type="text" name="ssid" placeholder="Nombre de la red Wi-Fi" required><br><br>

            <label>🔑 Contraseña:</label>
            <input type="password" id="password" name="password" placeholder="Contraseña" required>
            <label><input type="checkbox" id="showPassword" onclick="togglePassword()"> Ver Contraseña</label><br><br>

            <label>🏢 Bloque:</label>
            <select name="bloque" required>
                <option value="1">Bloque 1</option>
                <option value="2">Bloque 2</option>
                <option value="3">Bloque 3</option>
                <option value="4">Bloque 4</option>
            </select><br><br>

            <label>🏬 Piso:</label>
            <select name="piso" required>
                <option value="1">Piso 1</option>
                <option value="2">Piso 2</option>
                <option value="3">Piso 3</option>
                <option value="4">Piso 4</option>
                <option value="5">Piso 5</option>
            </select><br><br>

            <label>🔌 Nombre del Dispositivo:</label>
            <input type="text" name="dispositivo" placeholder="Ejemplo: Router TP-Link" required><br><br>

            <label>📡 Proveedor:</label>
            <select name="proveedor" required>
                <option value="tigo">Tigo</option>
                <option value="claro">Claro</option>
                <option value="liberty">Liberty</option>
            </select><br><br>

            <button type="submit">Registrar</button>
        </form>
    </div>

    <?php include 'footer.php'; ?>
</body>
</html>