<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

include 'db.php';

// Número de filas por página
 $rows_per_page = 7;

// Página actual
 $current_page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
 $current_page = max(1, $current_page);

// Construcción de la consulta base
 $conditions = "WHERE 1=1";
if (isset($_GET['bloque']) && !empty($_GET['bloque'])) {
    $bloque = $conn->real_escape_string($_GET['bloque']);
    $conditions .= " AND bloque = '$bloque'";
}
if (isset($_GET['piso']) && !empty($_GET['piso'])) {
    $piso = $conn->real_escape_string($_GET['piso']);
    $conditions .= " AND piso = '$piso'";
}

// Obtener el total de registros
 $total_rows_query = "SELECT COUNT(*) AS total FROM wifi_passwords $conditions";
 $total_rows_result = $conn->query($total_rows_query);
if (!$total_rows_result) {
    error_log("Error en la consulta de conteo: " . $conn->error);
    die("Error interno del servidor");
}
 $total_rows = $total_rows_result->fetch_assoc()['total'];

// Si no hay registros, establecemos $result como vacío
if ($total_rows == 0) {
    $result = null;
} else {
    // Cálculo del total de páginas
    $total_pages = ceil($total_rows / $rows_per_page);
    $current_page = min($current_page, $total_pages);
    $offset = ($current_page - 1) * $rows_per_page;

    // Consulta para obtener los datos
    $sql = "SELECT * FROM wifi_passwords $conditions LIMIT $rows_per_page OFFSET $offset";
    $result = $conn->query($sql);
    if (!$result) {
        error_log("Error en la consulta principal: " . $conn->error);
        die("Error interno del servidor");
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ver Redes Wi-Fi</title>
    <link rel="stylesheet" href="styles.css">
    <link rel="icon" href="favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        .btn-link {
            padding: 10px 20px;
            background-color: #2b3ca9;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            display: inline-block;
            margin: 5px 0;
        }
        .btn-link:hover {
            background-color: #0056b3;
        }
        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }
        .pagination a {
            margin: 0 5px;
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 5px;
        }
        .pagination a:hover {
            background-color: #0056b3;
        }
        .search-form {
            width: 80%; /* Ajusta el ancho del formulario */
            max-width: 600px; /* Ancho máximo del formulario */
            margin: 20px auto;
            padding: 20px;
            background-color: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        .search-form label, .search-form select, .search-form button {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        .search-form button {
            background-color: #2b3ca9;
            color: white;
            border: none;
            cursor: pointer;
        }
        .search-form button:hover {
            background-color: #0056b3;
        }
        .no-results {
            color: red;
            font-weight: bold;
            text-align: center;
        }
        .button-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 10px;
        }
        @media (min-width: 600px) {
            .button-container {
                flex-direction: row;
            }
        }
    </style>
</head>
<body>
     <?php include 'header.php'; ?>

    <main class="container">
        <h2 class="title"><i class="fa-solid fa-wifi"></i> Redes Wi-Fi Registradas</h2>

        <form method="GET" action="ver_wifi.php" class="search-form">
            <label for="bloque">Bloque:</label>
            <select id="bloque" name="bloque">
                <option value="">Selecciona un bloque</option>
                <?php for ($i = 1; $i <= 4; $i++): ?>
                    <option value="<?php echo $i; ?>" <?php echo (isset($_GET['bloque']) && $_GET['bloque'] == $i) ? 'selected' : ''; ?>>Bloque <?php echo $i; ?></option>
                <?php endfor; ?>
            </select>
            <label for="piso">Piso:</label>
            <select id="piso" name="piso">
                <option value="">Selecciona un piso</option>
                <?php for ($i = 1; $i <= 5; $i++): ?>
                    <option value="<?php echo $i; ?>" <?php echo (isset($_GET['piso']) && $_GET['piso'] == $i) ? 'selected' : ''; ?>>Piso <?php echo $i; ?></option>
                <?php endfor; ?>
            </select>
            <button type="submit"><i class="fa-solid fa-magnifying-glass"></i> Buscar</button>
        </form>

        <!-- =========================================== -->
        <!-- AHORA EL BOTÓN ES VISIBLE PARA TODOS -->
        <!-- =========================================== -->
        <div class="button-container">
            <a href="https://grupopolitecnicodecolombia.co/help/login" class="btn btn-link">
                <i class="fa-solid fa-ticket"></i> Colocar un Ticket
            </a>
            <a href="generar_offline.php" class="btn btn-link">
                <i class="fa-solid fa-download"></i> Descargar Contraseñas
            </a>
        </div>

        <table class="table">
            <thead>
                <tr>
                    <th>SSID</th>
                    <th>Bloque</th>
                    <th>Piso</th>
                    <th>Contraseña</th>
                    <?php if ($_SESSION['user_role'] == 'admin'): ?>
                        <th>Dispositivo</th>
                        <th>Proveedor</th>
                        <th>Acciones</th>
                    <?php endif; ?>
                </tr>
            </thead>
            <tbody>
                <?php if ($result && $result->num_rows > 0): ?>
                    <?php while ($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($row['ssid']); ?></td>
                            <td><?php echo htmlspecialchars($row['bloque']); ?></td>
                            <td><?php echo htmlspecialchars($row['piso']); ?></td>
                            <td><?php echo htmlspecialchars(openssl_decrypt($row['password'], 'AES-256-CBC', 'tu_clave_secreta', 0, 'tu_vector_inicializacion')); ?></td>
                            <?php if ($_SESSION['user_role'] == 'admin'): ?>
                                <td><?php echo htmlspecialchars($row['dispositivo']); ?></td>
                                <td><?php echo htmlspecialchars($row['proveedor']); ?></td>
                                <td>
                                    <a href="editar_wifi.php?id=<?php echo $row['id']; ?>" class="btn btn-edit">
                                        <i class="fa-solid fa-pen-to-square"></i> Editar
                                    </a> |
                                    <a href="eliminar_wifi.php?id=<?php echo $row['id']; ?>" class="btn btn-delete" onclick="return confirm('¿Seguro que quieres eliminar esta red Wi-Fi?')">
                                        <i class="fa-solid fa-trash"></i> Eliminar
                                    </a>
                                </td>
                            <?php endif; ?>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="<?php echo ($_SESSION['user_role'] == 'admin') ? 7 : 4; ?>" class="no-results">No se encontraron resultados.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <!-- Controles de paginación -->
        <?php if ($total_rows > 0): ?>
            <div class="pagination">
                <?php if ($current_page > 1): ?>
                    <a href="ver_wifi.php?page=<?php echo $current_page - 1; ?>">
                        <i class="fa-solid fa-arrow-left"></i> Anterior
                    </a>
                <?php endif; ?>

                <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                    <a href="ver_wifi.php?page=<?php echo $i; ?>" <?php echo ($i == $current_page) ? 'style="background-color: #032154;"' : ''; ?>>
                        <?php echo $i; ?>
                    </a>
                <?php endfor; ?>

                <?php if ($current_page < $total_pages): ?>
                    <a href="ver_wifi.php?page=<?php echo $current_page + 1; ?>">
                        Siguiente <i class="fa-solid fa-arrow-right"></i>
                    </a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </main>

    <?php include 'footer.php'; ?>
</body>
</html>